//shader deszczu na szybie lcddisplay

in vec2 f_coord;
in vec4 f_pos;
#include <common>

layout(location = 0) out vec4 out_color;

#if MOTIONBLUR_ENABLED
layout(location = 1) out vec4 out_motion;
#endif

#texture(diffuse,        0, sRGB_A)
#texture(raindropsatlas, 1, sRGB_A)

uniform sampler2D diffuse;
uniform sampler2D raindropsatlas;

uniform float specular_intensity = 0.1;
uniform float wobble_strength    = 0.002;
uniform float wobble_speed       = 30.0;

uniform float moveTime  = 0.5;
uniform float pauseTime = 0.2;
uniform float rain_scale = 1.25;

uniform float active_ratio = 0.25;

float hash(vec2 p) {
    return fract(sin(dot(p, vec2(12.9898, 78.233))) * 43758.5453);
}

vec4 getDropTex(float choice, vec2 uv) {
    vec2 offset;
    if      (choice < 0.25) offset = vec2(0.0, 0.0);
    else if (choice < 0.5)  offset = vec2(0.5, 0.0);
    else if (choice < 0.75) offset = vec2(0.0, 0.5);
    else                    offset = vec2(0.5, 0.5);
    return texture(raindropsatlas, offset + uv * 0.5);
}

void main() {
    vec4 uvCheck = texture(diffuse, f_coord);
    if (uvCheck.a < 0.01) discard;

    vec2 rainCoord = f_coord * rain_scale;

    const float numDrops      = 20000.0;
    const float cycleDuration = 4.0;
    const float squareMin     = 0.0035;
    const float squareMax     = 0.008;

    float gridSize = ceil(sqrt(numDrops));
    vec2  cell     = floor(rainCoord * gridSize);

    float rainMix = 1.0;

    vec3  dropLayer   = vec3(0.0);
    float dropMaskSum = 0.0;

    for (int oy = -1; oy <= 1; oy++) {
        for (int ox = -1; ox <= 1; ox++) {

            vec2 neighborCell = cell + vec2(ox, oy);
            float i = neighborCell.x + neighborCell.y * gridSize;

            float activationSeed = hash(vec2(i, 0.333));
            if (activationSeed > active_ratio)
                continue;

            vec2 dropCenter  = (neighborCell + vec2(hash(vec2(i, 0.12)), hash(vec2(i, 0.34)))) / gridSize;
            float squareSize = mix(squareMin, squareMax, hash(vec2(i, 0.56)));

            float lifeTime = time + hash(vec2(i, 0.78)) * cycleDuration;
            float phase    = fract(lifeTime / cycleDuration);
            float active   = clamp(1.0 - phase, 0.0, 1.0);

            float gravityStart  = 0.5;
            float gravityPhase  = smoothstep(gravityStart, 1.0, phase);
            float dropMass      = mix(0.3, 1.2, hash(vec2(i, 0.21)));
            float gravitySpeed  = 0.15 * dropMass;
            vec2  gravityOffset = vec2(0.0, gravityPhase * gravitySpeed * phase);

            bool hasWobble = (hash(vec2(i, 0.91)) < 0.10);
            vec2 wobbleOffset = vec2(0.0);
            if (hasWobble && gravityPhase > 0.0) {
                float intensity = sin(time * wobble_speed + i) * wobble_strength * gravityPhase;
                wobbleOffset = vec2(intensity, 0.0);
            }

            vec2 slideOffset = gravityOffset + wobbleOffset;

            float flattenAmount = smoothstep(0.1, 0.5, gravityPhase);
            float flattenX = mix(1.0, 0.4, flattenAmount);
            float stretchY = mix(1.0, 1.6, flattenAmount);

            vec2 diff = (rainCoord + slideOffset) - dropCenter;
            diff.x *= 1.0 / flattenX;
            diff.y *= 1.0 / stretchY;
            float mask = smoothstep(squareSize * 0.5, squareSize * 0.45, max(abs(diff.x), abs(diff.y)));

            if (mask > 0.001) {
                vec2  localUV   = (diff + squareSize * 0.5) / squareSize;
                float choice    = hash(vec2(i, 0.99));
                vec4  dropTex   = getDropTex(choice, localUV);
                float sharpAlpha = smoothstep(0.3, 0.9, dropTex.a);

                float ambLum   = clamp(dot(ambient, vec3(0.2126, 0.7152, 0.0722)), 0.0, 1.0);
                float sunFactor= pow(clamp(ambLum * 6.0, 0.0, 1.0), 0.5);
                float dynBright= mix(0.0, 0.5, sunFactor);

                float colorLuma  = length(dropTex.rgb);
                float alphaRange = smoothstep(0.1, 0.3, colorLuma);
                float blackAlpha = mix(0.25, 0.85, alphaRange);

                float sparkle = 0.0;
                if (hasWobble) {
                    sparkle = pow(abs(sin(f_coord.x * 8.0 + time * 2.0 + hash(vec2(i, 0.9)) * 6.2831)), 40.0)
                              * mix(0.2, 1.0, sunFactor);
                }

                vec3 specularColor = vec3(1.0) * specular_intensity * sparkle;
                vec3 dropLit = dropTex.rgb * dynBright + specularColor * sharpAlpha;

                dropLayer   += dropLit * sharpAlpha * active * blackAlpha * mask;
                dropMaskSum += sharpAlpha * active * blackAlpha * mask;
            }
        }
    }

    dropLayer   *= rainMix;
    dropMaskSum *= rainMix;

    vec3  finalMix = dropLayer;
    float alphaOut = clamp(dropMaskSum, 0.0, 1.0);
    out_color = vec4(finalMix, alphaOut);

#if MOTIONBLUR_ENABLED
    out_motion = vec4(0.0);
#endif
}
